@extends('layouts.app')

@section('title', 'Select Server - Store')

@section('content')
<div class="store-container">
    <div class="container">
        <!-- Store Header -->
        <div class="store-header">
            <h1 class="store-title">Select Your Server</h1>
            <p class="store-subtitle">Choose your preferred server to view available packages and enhance your gaming experience</p>
        </div>

        <!-- Server Selection Section -->
        <div class="server-selection-section">
            <div class="servers-grid">
                @foreach($servers as $server)
                <div class="server-card" data-server-id="{{ $server->id }}">
                    <div class="server-icon">
                        <i class="fas fa-server"></i>
                    </div>
                    <div class="server-info">
                        <h3>{{ $server->name }}</h3>
                        <p>{{ $server->description ?? 'Experience premium gameplay with exclusive features and content.' }}</p>
                        
                        <div class="server-stats">
                            <div class="stat">
                                <i class="fas fa-users"></i>
                                <span>{{ $server->player_count ?? 'Active' }} Players</span>
                            </div>
                            <div class="stat">
                                <i class="fas fa-box"></i>
                                <span>{{ $server->packages()->where('is_active', true)->count() }} Packages</span>
                            </div>
                        </div>
                        
                        @if($server->is_featured)
                        <div class="server-badge">
                            <i class="fas fa-star"></i>
                            Featured
                        </div>
                        @endif
                    </div>
                    <div class="server-actions">
                        <a href="{{ route('store.index', ['server_id' => $server->id]) }}" class="btn-select-server">
                            <span>Select Server</span>
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Browse All Option -->
            <div class="browse-all-section">
                <div class="browse-all-card">
                    <div class="browse-all-content">
                        <h3>Browse All Packages</h3>
                        <p>View packages available across all servers without selecting a specific server</p>
                    </div>
                    <a href="{{ route('store.index', ['server_id' => '']) }}" class="btn-browse-all">
                        <span>Browse All</span>
                        <i class="fas fa-globe"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection